class LifePlan {
    Asset asset
    Form form
    Frequency frequency
    AssetType assetType
    Assembly assembly
    SubAssembly subAssembly
    ComponentItem componentItem

    String name
    String description = ""
    String resourceNumber = ""
    Integer timeInHours
    String maintenanceAction
    String notes = ""
    
    boolean isActive = true

    static hasMany = [systemSections: SystemSection]

    static belongsTo = [SystemSection]

    static constraints = {
        asset(blank:true,nullable:true)
        form(blank:true,nullable:true)
        frequency(blank:true,nullable:true)
        assetType(blank:true,nullable:true)
        assembly(blank:true,nullable:true)
        subAssembly(blank:true,nullable:true)
        componentItem(blank:true,nullable:true)
    }

    String toString() {
        "${this.name}"
    }
}

