

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Section</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${sectionInstance}">
            <div class="errors">
                <g:renderErrors bean="${sectionInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${sectionInstance?.id}" />
                <input type="hidden" name="version" value="${sectionInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:sectionInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:sectionInstance,field:'description')}"/>
                                </td>
                            </tr> 
                            
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:sectionInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${sectionInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assets">Assets:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'assets','errors')}">
                                    
<ul>
<g:each var="a" in="${sectionInstance?.assets?}">
    <li><g:link controller="assetDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assetDetailed" params="['section.id':sectionInstance?.id]" action="create">+Add Asset</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="department">Department:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'department','errors')}">
                                    <g:select optionKey="id" from="${Department.list()}" name="department.id" value="${sectionInstance?.department?.id}" ></g:select>
                                    <p>
                                        <g:link controller="departmentDetailed" action="create">+Add Department</g:link>
                                    </p>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${sectionInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceActionDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceActionDetailed" params="['section.id':sectionInstance?.id]" action="create">+Add Maintenance Action</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="sectionExtendedAttributes">Section Extended Attributes:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'sectionExtendedAttributes','errors')}">
                                    
<ul>
<g:each var="s" in="${sectionInstance?.sectionExtendedAttributes?}">
    <li><g:link controller="sectionExtendedAttributeDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="sectionExtendedAttributeDetailed" params="['section.id':sectionInstance?.id]" action="create">+Add Extended Attribute</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="site">Site:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:sectionInstance,field:'site','errors')}">
                                    <g:select optionKey="id" from="${Site.list()}" name="site.id" value="${sectionInstance?.site?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
