class Image implements Comparable {

    Picture picture
    Integer size
    byte[] data
    String contentType
    Integer width
    Integer height
    Date dateCreated = new Date()
    Date lastUpdated = new Date()

    static belongsTo = [ Picture ]

    static mapping = {
        data type: 'binary'
    }

    static constraints = {
        data(maxSize: MAX_SIZE)
        size(unique:'picture')
    }

    static final Integer MAX_SIZE = 10 * 1024 * 1024

    static final Integer Original = 1
    static final Integer Large = 2
    static final Integer Medium = 3
    static final Integer Small = 4

    static final Integer[] Widths =  [ 0, 0, 500, 250, 100 ]
    static final Integer[] Heights = [ 0, 0, 500, 250, 100 ]

    static final String[] Names = [ '', 'Original', 'Large', 'Medium', 'Small' ]

    int compareTo(obj) {
        size.compareTo(obj.size)
    }

    String filename() {
        Image.filename(picture.id, size)
    }

    static String filename(long id, int size) {
        if (size == Original) {
            return "${id}-${Names[size]}.jpg"
        }
        else {
            return "${id}-${Names[size]}.png"
        }
    }
}