class Section {

    Site site
    Department department

    String name
    String description = ""
    String comment = ""
    boolean isActive = true

    static hasMany = [assets: Asset,
                                maintenanceActions: MaintenanceAction,
                                sectionExtendedAttributes: SectionExtendedAttribute]

    static belongsTo = [Site]

    static constraints = {
        name(maxSize:50, unique:true, blank:false)
        description(maxSize:75)
        comment(maxSize:500)
        isActive()
    }

    static mapping = {
        assets(batchSize:1000)
    }

    String toString() {
        "${this.name}"
    }
}

