grails.project.class.dir = "target/classes"
grails.project.test.class.dir = "target/test-classes"
grails.project.test.reports.dir	= "target/test-reports"

def env = System.getProperty('grails.env')

switch (env) {
    case "production":
        //grails.project.war.file = "target/${appName}-${appVersion}.war"
        grails.project.war.file="target/${appName}Live.war"
        break
    case "development":
        grails.project.war.file="target/${appName}Dev.war"
        break
    default:
        grails.project.war.file="target/${appName}.war"
        break
}

grails.war.resources = { stagingDir, args ->
    // Remove some duplicate jars.
    delete file: "${stagingDir}/WEB-INF/lib/jasperreports-2.0.5.jar"
    delete file: "${stagingDir}/WEB-INF/lib/jasperreports-3.1.2.jar"
    delete file: "${stagingDir}/WEB-INF/lib/aspectjrt-1.5.4.jar"
    delete file: "${stagingDir}/WEB-INF/lib/commons-digester-1.7.jar"
    delete file: "${stagingDir}/WEB-INF/lib/iText-2.0.8.jar"
    delete file: "${stagingDir}/WEB-INF/lib/iText-2.1.5.jar"
    delete file: "${stagingDir}/WEB-INF/lib/jfreechart-1.0.3.jar"
    delete file: "${stagingDir}/WEB-INF/lib/poi-3.0.2-FINAL-20080204.jar"
    delete file: "${stagingDir}/WEB-INF/lib/facebook-2.0.4.jar"
    // Included by searchable plugin.
    delete file: "${stagingDir}/WEB-INF/lib/compass-2.1.0.jar"
    delete file: "${stagingDir}/WEB-INF/lib/compass-2.1.0-src.jar"
    delete file: "${stagingDir}/WEB-INF/lib/lucene-core.jar"
    delete file: "${stagingDir}/WEB-INF/lib/lucene-analyzers.jar"
    delete file: "${stagingDir}/WEB-INF/lib/lucene-highlighter.jar"
    delete file: "${stagingDir}/WEB-INF/lib/lucene-queries.jar"
    delete file: "${stagingDir}/WEB-INF/lib/lucene-snowball.jar"
    delete file: "${stagingDir}/WEB-INF/lib/lucene-spellchecker.jar"
}

grails.project.dependency.resolution = {

    // inherit Grails' default dependencies
    inherits( "global" ) {
        // uncomment to disable ehcache
        // excludes 'ehcache'
    }

    log "warn" // log level of Ivy resolver, either 'error', 'warn', 'info', 'debug' or 'verbose'

    repositories {
        grailsPlugins()
        grailsHome()

        // uncomment the below to enable remote dependency resolution
        // from public Maven repositories
        //mavenLocal()
        mavenCentral()
        //mavenRepo "http://snapshots.repository.codehaus.org"
        //mavenRepo "http://repository.codehaus.org"
        //mavenRepo "http://download.java.net/maven/2/"
        //mavenRepo "http://repository.jboss.com/maven2/"
    }

    dependencies {
        // specify dependencies here under either 'build', 'compile', 'runtime', 'test' or 'provided' scopes eg.

        runtime 'mysql:mysql-connector-java:5.1.9'

        runtime ('org.apache.poi:poi:3.5-FINAL') {
            excludes 'servlet-api', 'commons-logging', 'log4j'
        }

        runtime ('net.sf.jasperreports:jasperreports:3.7.2') {
            excludes 'xml-apis'
        }

        runtime ('org.compass-project:compass:2.1.4')
        runtime ('org.apache.lucene:lucene-core:2.4.1')
        runtime ('org.apache.lucene:lucene-analyzers:2.4.1')
        runtime ('org.apache.lucene:lucene-highlighter:2.4.1')
        runtime ('org.apache.lucene:lucene-queries:2.4.1')
        runtime ('org.apache.lucene:lucene-snowball:2.4.1')
        runtime ('org.apache.lucene:lucene-spellchecker:2.4.1')

        runtime ('org.apache.ant:ant:1.7.1')
        runtime ('org.apache.ant:ant-launcher:1.7.1')

    }

}
