import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class EntryTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ entryTypeInstanceList: EntryType.list( params ), entryTypeInstanceTotal: EntryType.count() ]
    }

    def show = {
        def entryTypeInstance = EntryType.get( params.id )

        if(!entryTypeInstance) {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ entryTypeInstance : entryTypeInstance ] }
    }

    def delete = {
        def entryTypeInstance = EntryType.get( params.id )
        if(entryTypeInstance) {
            try {
                entryTypeInstance.delete(flush:true)
                flash.message = "EntryType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "EntryType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def entryTypeInstance = EntryType.get( params.id )

        if(!entryTypeInstance) {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ entryTypeInstance : entryTypeInstance ]
        }
    }

    def update = {
        def entryTypeInstance = EntryType.get( params.id )
        if(entryTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(entryTypeInstance.version > version) {
                    
                    entryTypeInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[entryTypeInstance:entryTypeInstance])
                    return
                }
            }
            entryTypeInstance.properties = params
            if(!entryTypeInstance.hasErrors() && entryTypeInstance.save(flush: true)) {
                flash.message = "EntryType ${params.id} updated"
                redirect(action:show,id:entryTypeInstance.id)
            }
            else {
                render(view:'edit',model:[entryTypeInstance:entryTypeInstance])
            }
        }
        else {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def entryTypeInstance = new EntryType()
        entryTypeInstance.properties = params
        return ['entryTypeInstance':entryTypeInstance]
    }

    def save = {
        def entryTypeInstance = new EntryType(params)
        if(!entryTypeInstance.hasErrors() && entryTypeInstance.save(flush: true)) {
            flash.message = "EntryType ${entryTypeInstance.id} created"
            redirect(action:show,id:entryTypeInstance.id)
        }
        else {
            render(view:'create',model:[entryTypeInstance:entryTypeInstance])
        }
    }
}
