

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create TaskGroup</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${taskGroupInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskGroupInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskGroupInstance,field:'name','errors')}">
                                    <input type="text" maxlength="50" id="name" name="name" value="${fieldValue(bean:taskGroupInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskGroupInstance,field:'description','errors')}">
                                    <input type="text" maxlength="100" id="description" name="description" value="${fieldValue(bean:taskGroupInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskGroupInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${taskGroupInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
