class CostCode {

    PurchasingGroup purchasingGroup

    String name
    String description = ""
    boolean isActive = true

    static hasMany = [inventoryItemPurchases: InventoryItemPurchase]

    static constraints = {
        name(blank:false, maxSize:50, validator: {val, obj ->
            // Name must be unique for a purchasingGroup.
            def list = CostCode.withCriteria {
                eq('purchasingGroup', obj.purchasingGroup)
                eq('name', obj.name)
                if(obj.id)
                    notEqual('id', obj.id)
            }
            if(list.size() > 0)
                return 'not.unique.for.purchasing.group'
            // Success.
            return true
        })
        description(maxSize:100)
    }

    String toString() {
        "${this.name}.${this.purchasingGroup}"
    }

}
