/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.tools.xritracert;

import java.net.URL;
import java.net.URLConnection;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.XRIResolutionException;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class XRITraceRt {
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final String CMD_HELP = "help";
    private static final String OPT_ROOT_EQUALS_URI = "-root_equals_auth";
    private static final String OPT_ROOT_AT_URI = "-root_at_auth";
    private static final String OPT_VERBOSE = "-verbose";
    private static final String OPT_NO_HEADER = "-no_header";
    private static final String ROOT_DEF_URI = "http://localhost:8080/xri/resolve?ns=at";
    private String msTargetXRI;
    private boolean mbIsVerbose;
    private boolean mbDontOutputHeader;
    private String msRootEqualsURI;
    private String msRootAtURI;

    public static void main(String[] oArgs) {
        StringBuffer sOutput = new StringBuffer();
        XRITraceRt oTraceRt = new XRITraceRt();
        int iResult = oTraceRt.process(sOutput, oArgs);
        XRITraceRt.exit(sOutput, iResult);
    }

    public int process(StringBuffer sOutput, String[] sArgs) {
        try {
            sOutput.setLength(0);
            this.msTargetXRI = null;
            this.mbIsVerbose = false;
            this.mbDontOutputHeader = false;
            this.msRootEqualsURI = ROOT_DEF_URI;
            this.msRootAtURI = ROOT_DEF_URI;
            if (sArgs.length == 0) {
                this.outputPleaseTypeHelp(sOutput);
                return 1;
            }
            if (sArgs[0].equalsIgnoreCase(CMD_HELP)) {
                this.outputUsage(sOutput);
                return 0;
            }
            int iResult = this.scanArgs(sOutput, sArgs);
            if (iResult == 1) {
                return 1;
            }
            iResult = this.validateRootURIs(sOutput);
            if (iResult == 1) {
                return 1;
            }
            Resolver resolver = new Resolver();
            XRD eqRoot = new XRD();
            Service eqAuthService = new Service();
            eqAuthService.addMediaType("application/xrds+xml;trust=none");
            eqAuthService.addType("xri://$res*auth*($v*2.0)");
            eqAuthService.addURI(this.msRootEqualsURI);
            eqRoot.addService(eqAuthService);
            XRD atRoot = new XRD();
            Service atAuthService = new Service();
            atAuthService.addMediaType("application/xrds+xml;trust=none");
            atAuthService.addType("xri://$res*auth*($v*2.0)");
            atAuthService.addURI(this.msRootAtURI);
            atRoot.addService(atAuthService);
            resolver.setAuthority("=", eqRoot);
            resolver.setAuthority("@", atRoot);
            this.tracert(sOutput, resolver);
        }
        catch (Throwable oThrowable) {
            this.outputException(sOutput, oThrowable);
            return 1;
        }
        return 0;
    }

    private void tracert(StringBuffer sOutput, Resolver resolver) throws XRIResolutionException {
        TrustType trustType = new TrustType("none");
        boolean followRefs = true;
        XRDS xrds = resolver.resolveAuthToXRDS(this.msTargetXRI, trustType, followRefs);
        String sCol1Header = "     resolved subsegment";
        String sCol2Header = "resolved by";
        String sCol1Border = "------------------------";
        String sCol2Border = "--------------------------------------------";
        String sColGap = "  ";
        String sLeftHeaderPad = "   ";
        StringBuffer sTraceHops = new StringBuffer();
        boolean iAuthorityHops = false;
    }

    private int scanArgs(StringBuffer sOutput, String[] sArgs) {
        for (int i = 0; i < sArgs.length; ++i) {
            String sArg = sArgs[i];
            if (!this.isOption(sArg)) {
                if (this.msTargetXRI == null) {
                    this.msTargetXRI = sArg;
                    continue;
                }
                this.outputPleaseTypeHelp(sOutput);
                return 1;
            }
            if (sArg.equalsIgnoreCase(OPT_VERBOSE)) {
                this.mbIsVerbose = true;
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_ROOT_AT_URI)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_ROOT_AT_URI);
                    return 1;
                }
                this.msRootAtURI = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_ROOT_EQUALS_URI)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_ROOT_EQUALS_URI);
                    return 1;
                }
                this.msRootEqualsURI = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_NO_HEADER)) {
                this.mbDontOutputHeader = true;
                continue;
            }
            sOutput.append("Invalid option: " + sArg + "\n");
            this.outputPleaseTypeHelp(sOutput);
            return 1;
        }
        if (this.msTargetXRI == null) {
            sOutput.append("Must specify target XRI. \n");
            this.outputPleaseTypeHelp(sOutput);
            return 1;
        }
        return 0;
    }

    private int validateRootURIs(StringBuffer sOutput) {
        String sCurURI = null;
        try {
            sCurURI = this.msRootEqualsURI;
            URL oURL = new URL(sCurURI);
            URLConnection oConn = oURL.openConnection();
            oConn.connect();
            sCurURI = this.msRootAtURI;
            oURL = new URL(sCurURI);
            oConn = oURL.openConnection();
            oConn.connect();
        }
        catch (Throwable oThrowable) {
            sOutput.append("Cannot cannect to root authority URI: " + sCurURI);
            return 1;
        }
        return 0;
    }

    private void outputUsage(StringBuffer sOutput) {
        sOutput.append("\nusage: 1. xritracert <XRI> [options] \n       2. xritracert help \n\nThe first form resolves the given <XRI> and outputs the URIs for \nthe registry servers used at each step of the resolution. \n\nExample usage: xritracert xri://@community*member*family \n\nRefer to the OASIS document \"Extensible Resource Identifier (XRI) \nResolution\" for information about XRI resolution. \n\nThe second form generates this help message. \n\nAvailable options: \n    -root_equals_auth <URI>: Root authority URI for '=' resolution. \n    -root_at_auth <URI>:     Root authority URI for '@' resolution. \n\n    -verbose:        Print verbose output. \n    -no_header:      Omit header from non-verbose output. \n\nThe default value (used if unspecified) for the two '-root_' options \nis http://localhost:8080/xri/resolve?ns=at. \n\nProgram output: \n    For successful invocation, 0 is returned with program \n    output on stdout. Otherwise 1 is returned with error \n    message output on stderr. \n\nN.B.: \n    The server script \"regexample\" can be used to register \n    subsegments and create authorities. \n \n\n");
    }

    private boolean isOption(String sArg) {
        return sArg.charAt(0) == '-';
    }

    private void outputPleaseTypeHelp(StringBuffer sOutput) {
        sOutput.append("Type \"xritracert help\". \n");
    }

    private void outputOptionRequiresArgument(StringBuffer sOutput, String sOption) {
        sOutput.append("Option: " + sOption + " requires argument.\n");
        this.outputPleaseTypeHelp(sOutput);
    }

    void outputChars(StringBuffer sOutput, char c, int num) {
        char[] cArray = new char[num];
        for (int i = 0; i < num; ++i) {
            cArray[i] = c;
        }
        sOutput.append(cArray);
    }

    private void outputException(StringBuffer sOutput, Throwable oThrowable) {
        String message = oThrowable.getLocalizedMessage();
        sOutput.append(oThrowable.getClass().getName() + ": " + message + "\n");
        if (this.mbIsVerbose) {
            oThrowable.printStackTrace();
        }
    }

    private static void exit(StringBuffer sOutput, int iStatus) {
        if (iStatus == 1) {
            System.err.print(sOutput);
        } else {
            System.out.print(sOutput);
        }
        System.exit(iStatus);
    }
}

