/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder.wrappers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.parserapplications.filterbuilder.Filter;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class TagNameFilterWrapper
extends Filter
implements ActionListener {
    protected TagNameFilter mFilter = new TagNameFilter();
    protected JComboBox mName = new JComboBox();

    public TagNameFilterWrapper() {
        this.mName.setEditable(true);
        this.add(this.mName);
        this.mName.addItem(this.mFilter.getName());
        this.mName.addActionListener(this);
    }

    public String getDescription() {
        return "Tag named";
    }

    public String getIconSpec() {
        return "images/TagNameFilter.gif";
    }

    public NodeFilter getNodeFilter() {
        TagNameFilter ret = new TagNameFilter();
        ret.setName(this.mFilter.getName());
        return ret;
    }

    public void setNodeFilter(NodeFilter filter, Parser context) {
        Object iterator;
        this.mFilter = (TagNameFilter)filter;
        HashSet set = new HashSet();
        context.reset();
        try {
            iterator = context.elements();
            while (iterator.hasMoreNodes()) {
                this.addName(set, iterator.nextNode());
            }
        }
        catch (ParserException pe) {
            // empty catch block
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            this.mName.addItem(iterator.next());
        }
        this.mName.setSelectedItem(this.mFilter.getName());
    }

    public NodeFilter[] getSubNodeFilters() {
        return new NodeFilter[0];
    }

    public void setSubNodeFilters(NodeFilter[] filters) {
    }

    public String toJavaCode(StringBuffer out, int[] context) {
        int n = context[1];
        context[1] = n + 1;
        String ret = "filter" + n;
        TagNameFilterWrapper.spaces(out, context[0]);
        out.append("TagNameFilter ");
        out.append(ret);
        out.append(" = new TagNameFilter ();");
        TagNameFilterWrapper.newline(out);
        TagNameFilterWrapper.spaces(out, context[0]);
        out.append(ret);
        out.append(".setName (\"");
        out.append(this.mFilter.getName());
        out.append("\");");
        TagNameFilterWrapper.newline(out);
        return ret;
    }

    protected void addName(Set set, Node node) {
        if (node instanceof Tag) {
            NodeList children;
            set.add(((Tag)node).getTagName());
            if (node instanceof CompositeTag && null != (children = ((CompositeTag)node).getChildren())) {
                for (int i = 0; i < children.size(); ++i) {
                    this.addName(set, children.elementAt(i));
                }
            }
        }
    }

    public boolean accept(Node node) {
        return this.mFilter.accept(node);
    }

    public void actionPerformed(ActionEvent event) {
        Object[] selection;
        Object source = event.getSource();
        if (source == this.mName && null != (selection = this.mName.getSelectedObjects()) && 0 != selection.length) {
            this.mFilter.setName((String)selection[0]);
        }
    }
}

