/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.control;

import com.sun.jndi.ldap.ctl.SortControl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.springframework.ldap.control.AbstractRequestControlDirContextProcessor;
import org.springframework.ldap.control.CreateControlFailedException;
import org.springframework.util.ReflectionUtils;

public class SortControlDirContextProcessor
extends AbstractRequestControlDirContextProcessor {
    private static final Class DEFAULT_RESPONSE_CONTROL = class$com$sun$jndi$ldap$ctl$SortResponseControl == null ? (class$com$sun$jndi$ldap$ctl$SortResponseControl = SortControlDirContextProcessor.class$("com.sun.jndi.ldap.ctl.SortResponseControl")) : class$com$sun$jndi$ldap$ctl$SortResponseControl;
    private static final boolean CRITICAL_CONTROL = true;
    private static final String JAVA5_RESPONSE_CONTROL = "javax.naming.ldap.SortResponseControl";
    private String sortKey;
    private boolean sorted;
    private int resultCode;
    private Class responseControlClass = DEFAULT_RESPONSE_CONTROL;
    private Class fallbackResponseControlClass;
    private Class currentResponseControlClass;
    static /* synthetic */ Class class$com$sun$jndi$ldap$ctl$SortResponseControl;

    public SortControlDirContextProcessor(String sortKey) {
        this.sortKey = sortKey;
        this.fallbackResponseControlClass = this.loadFallbackResponseControlClass();
        this.setSorted(false);
        this.setResultCode(-1);
    }

    public void setResponseControlClass(Class responseControlClass) {
        this.responseControlClass = responseControlClass;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    private void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    private void setResultCode(int sortResult) {
        this.resultCode = sortResult;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public Control createRequestControl() {
        try {
            return new SortControl(new String[]{this.sortKey}, true);
        }
        catch (IOException e) {
            throw new CreateControlFailedException("Error creating SortControl", e);
        }
    }

    public void postProcess(DirContext ctx) throws NamingException {
        this.currentResponseControlClass = this.responseControlClass;
        LdapContext ldapContext = (LdapContext)ctx;
        Control[] responseControls = ldapContext.getResponseControls();
        if (responseControls == null) {
            return;
        }
        for (int i = 0; i < responseControls.length; ++i) {
            Control responseControl = responseControls[i];
            if (!this.isSortResponseControl(responseControl)) continue;
            Control control = responseControl;
            Boolean result = (Boolean)this.invokeMethod("isSorted", this.currentResponseControlClass, control);
            this.setSorted(result);
            Integer code = (Integer)this.invokeMethod("getResultCode", this.currentResponseControlClass, control);
            this.setResultCode(code);
        }
    }

    private boolean isSortResponseControl(Control responseControl) {
        if (responseControl.getClass().isAssignableFrom(this.currentResponseControlClass)) {
            return true;
        }
        if (this.fallbackResponseControlClass != null && responseControl.getClass().isAssignableFrom(this.fallbackResponseControlClass)) {
            this.currentResponseControlClass = this.fallbackResponseControlClass;
            return true;
        }
        return false;
    }

    private Class loadFallbackResponseControlClass() {
        Class<?> fallbackResponseControlClass = null;
        try {
            fallbackResponseControlClass = Class.forName(JAVA5_RESPONSE_CONTROL);
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)"Could not load Java5 response control class javax.naming.ldap.SortResponseControl");
        }
        return fallbackResponseControlClass;
    }

    private Object invokeMethod(String method, Class clazz, Object control) {
        Method actualMethod = null;
        Object retval = null;
        try {
            actualMethod = clazz.getMethod(method, new Class[0]);
        }
        catch (SecurityException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (NoSuchMethodException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        try {
            retval = actualMethod.invoke(control, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

