/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.openxri.XRIParseException;
import org.openxri.resolve.exception.XRIResolutionException;
import org.openxri.saml.Assertion;
import org.openxri.util.DOM3Utils;
import org.openxri.util.DOMUtils;
import org.openxri.util.PrioritizedList;
import org.openxri.util.XMLUtils;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.Expires;
import org.openxri.xml.LocalID;
import org.openxri.xml.ProviderID;
import org.openxri.xml.Query;
import org.openxri.xml.Ref;
import org.openxri.xml.Service;
import org.openxri.xml.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XRD
implements Cloneable {
    public static final String CURRENT_VERSION = "2.0";
    private static Log soLog = LogFactory.getLog((String)XRD.class.getName());
    private String id = null;
    private String idRef = null;
    private String version = null;
    private Query query = null;
    private Status status = null;
    private Expires expires = null;
    private ProviderID providerid = null;
    private Vector localIDs = null;
    private Vector canonicalIDs = null;
    private Vector refs = null;
    private PrioritizedList prioritizedRefs = null;
    private Vector services = null;
    private PrioritizedList prioritizedServices = null;
    private PrioritizedList selectedServices = null;
    private String msXmlID = "";
    private Assertion moSAMLAssertion = null;
    private Element moElem = null;
    private HashMap moOtherChildrenVectorsMap = new HashMap();

    public XRD() {
    }

    public boolean setOtherTagValues(String sTag, String sTagValue) {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sTagValue;
        boolean returnValue = false;
        try {
            ByteArrayInputStream oIn = new ByteArrayInputStream(xmlStr.getBytes());
            DOMParser oDOMParser = DOMUtils.getDOMParser();
            oDOMParser.parse(new InputSource(oIn));
            Document oDOMDoc = oDOMParser.getDocument();
            Element oElement = oDOMDoc.getDocumentElement();
            Vector<Node> oVector = (Vector<Node>)this.moOtherChildrenVectorsMap.get(sTag);
            if (oVector == null) {
                oVector = new Vector<Node>();
                this.moOtherChildrenVectorsMap.put(sTag, oVector);
            }
            oVector.add(oElement.cloneNode(true));
            returnValue = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            returnValue = false;
        }
        return returnValue;
    }

    public Vector getOtherTagValues(String sTag) {
        return (Vector)this.moOtherChildrenVectorsMap.get(sTag);
    }

    public static XRD constructXRIDescriptor(String sValue, boolean bKeepDOM) throws URISyntaxException, ParseException {
        ByteArrayInputStream oIn = new ByteArrayInputStream(sValue.getBytes());
        XRD oXriD = null;
        try {
            DOMParser oDOMParser = DOMUtils.getDOMParser();
            oDOMParser.parse(new InputSource(oIn));
            Document oDOMDoc = oDOMParser.getDocument();
            Element oElement = oDOMDoc.getDocumentElement();
            oXriD = new XRD(oElement, bKeepDOM);
        }
        catch (IOException oEx) {
            oEx.printStackTrace();
            throw new XRIParseException("IOException", (Exception)oEx);
        }
        catch (SAXException oEx) {
            oEx.printStackTrace();
            throw new XRIParseException("SAXException", (Exception)oEx);
        }
        finally {
            try {
                ((InputStream)oIn).close();
            }
            catch (IOException e) {}
        }
        return oXriD;
    }

    public XRD(Element oElem, boolean bKeepDOM) throws URISyntaxException, ParseException {
        if (bKeepDOM) {
            this.setDOM(oElem);
        } else {
            this.fromDOM(oElem);
        }
    }

    public String getXmlID() {
        return this.msXmlID;
    }

    public void setXmlID(String sVal) {
        this.msXmlID = sVal;
    }

    public void genXmlID() {
        this.msXmlID = XMLUtils.genXmlID();
    }

    public String getProviderID() {
        return this.providerid != null ? this.providerid.getValue() : null;
    }

    public void setProviderID(String sVal) {
        this.providerid = new ProviderID(sVal);
    }

    public String getQuery() {
        return this.query != null ? this.query.getValue() : null;
    }

    public void setQuery(String sVal) {
        if (this.query != null) {
            this.query.setValue(sVal);
        } else {
            this.query = new Query(sVal);
        }
    }

    public Date getExpires() {
        return this.expires != null ? this.expires.getDate() : null;
    }

    public void setExpires(Date sVal) {
        if (this.expires != null) {
            this.expires.setDate(sVal);
        } else {
            this.expires = new Expires(sVal);
        }
    }

    public URI getURI() {
        Service srv = this.getFirstServiceByType("xri://$res*auth*($v*2.0)");
        if (srv != null && srv.getURI() != null) {
            return srv.getURI().getURI();
        }
        return null;
    }

    public int getNumLocalids() {
        return this.localIDs != null ? this.localIDs.size() : 0;
    }

    public LocalID getLocalidAt(int n) {
        return n < this.getNumLocalids() ? (LocalID)this.localIDs.get(n) : null;
    }

    public int getNumCanonicalids() {
        return this.canonicalIDs != null ? this.canonicalIDs.size() : 0;
    }

    public CanonicalID getCanonicalidAt(int n) {
        return n < this.getNumCanonicalids() ? (CanonicalID)this.canonicalIDs.get(n) : null;
    }

    public Ref getRefAt(int n) {
        return n < this.getNumRefs() ? (Ref)this.refs.get(n) : null;
    }

    public int getNumRefs() {
        return this.refs != null ? this.refs.size() : 0;
    }

    public void addRef(Ref ref) {
        Integer priority = ref.getPriority();
        if (this.refs == null || this.prioritizedRefs == null) {
            this.refs = new Vector();
            this.prioritizedRefs = new PrioritizedList();
        }
        this.refs.add(ref);
        this.prioritizedRefs.addObject(priority == null ? "null" : priority.toString(), ref);
    }

    public ArrayList getPrioritizedRefs() {
        if (this.prioritizedRefs == null) {
            return new ArrayList();
        }
        return this.prioritizedRefs.getList();
    }

    public Vector getServicesByType(String srvType) {
        Vector<Service> retv = new Vector<Service>();
        for (int i = 0; i < this.getNumServices(); ++i) {
            Service srv = this.getServiceAt(i);
            if (!srv.matchType(srvType)) continue;
            retv.add(srv);
        }
        return retv;
    }

    public Service getFirstServiceByType(String srvType) {
        Vector services = this.getServicesByType(srvType);
        if (services == null || services.size() == 0) {
            return null;
        }
        return (Service)services.elementAt(0);
    }

    public int getNumServices() {
        return this.services == null ? 0 : this.services.size();
    }

    public Service getServiceAt(int n) {
        return n < this.getNumServices() ? (Service)this.services.get(n) : null;
    }

    public Service getServiceForType(String sService) {
        for (int i = 0; i < this.services.size(); ++i) {
            Service oService = (Service)this.services.get(i);
            if (!oService.matchType(sService)) continue;
            return oService;
        }
        return null;
    }

    public ArrayList getPrioritizedServices() {
        if (this.prioritizedServices == null) {
            return new ArrayList();
        }
        return this.prioritizedServices.getList();
    }

    public void addService(Service service) {
        if (this.services == null || this.prioritizedServices == null) {
            this.services = new Vector();
            this.prioritizedServices = new PrioritizedList();
        }
        this.services.add(service);
        Integer priority = service.getPriority();
        this.prioritizedServices.addObject(priority == null ? "null" : priority.toString(), service);
    }

    public Assertion getSAMLAssertion() {
        return this.moSAMLAssertion;
    }

    public void setSAMLAssertion(Assertion oSAMLAssertion) {
        this.moSAMLAssertion = oSAMLAssertion;
    }

    public void reset() {
        this.msXmlID = "";
        this.query = null;
        this.status = null;
        this.expires = null;
        this.providerid = null;
        this.localIDs = null;
        this.canonicalIDs = null;
        this.refs = null;
        this.services = null;
        this.moElem = null;
    }

    public Object clone() {
        XRD x = new XRD();
        x.id = this.id;
        x.idRef = this.idRef;
        x.version = this.version;
        x.query = new Query(this.query);
        x.status = new Status(this.status);
        x.expires = new Expires(this.expires);
        x.providerid = new ProviderID(this.providerid);
        if (this.localIDs != null) {
            x.localIDs = (Vector)this.localIDs.clone();
        }
        if (this.canonicalIDs != null) {
            x.canonicalIDs = (Vector)this.canonicalIDs.clone();
        }
        if (this.refs != null) {
            x.refs = (Vector)this.refs.clone();
        }
        if (this.services != null) {
            x.services = (Vector)this.services.clone();
        }
        x.msXmlID = this.msXmlID;
        x.moSAMLAssertion = this.moSAMLAssertion;
        x.moElem = this.moElem;
        if (this.moOtherChildrenVectorsMap != null) {
            x.moOtherChildrenVectorsMap = (HashMap)this.moOtherChildrenVectorsMap.clone();
        }
        return x;
    }

    public void fromDOM(Element oElem) throws URISyntaxException, ParseException {
        this.reset();
        if (oElem.hasAttributeNS(null, "id")) {
            this.msXmlID = oElem.getAttributeNS(null, "id");
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            if (oChild.getLocalName().equals("Query")) {
                Query q = new Query();
                q.fromXML(oChild);
                this.query = q;
            } else if (oChild.getLocalName().equals("Status")) {
                Status s = new Status();
                s.fromXML(oChild);
                this.status = s;
            } else if (oChild.getLocalName().equals("Expires")) {
                this.expires = new Expires(DOMUtils.fromXMLDateTime(oChild.getFirstChild().getNodeValue()));
            } else if (oChild.getLocalName().equals("ProviderID")) {
                ProviderID p = new ProviderID();
                p.fromXML(oChild);
                this.providerid = p;
            } else if (oChild.getLocalName().equals("LocalID")) {
                if (this.localIDs == null) {
                    this.localIDs = new Vector();
                }
                this.localIDs.add(new LocalID(oChild));
            } else if (oChild.getLocalName().equals("CanonicalID")) {
                if (this.canonicalIDs == null) {
                    this.canonicalIDs = new Vector();
                }
                this.canonicalIDs.add(new CanonicalID(oChild));
            } else if (oChild.getLocalName().equals("Ref")) {
                Ref ref = new Ref(oChild);
                this.addRef(ref);
            } else if (oChild.getLocalName().equals("Service")) {
                this.addService(new Service(oChild));
            } else if (oChild.getNamespaceURI() != null && oChild.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion") && oChild.getLocalName() != null && oChild.getLocalName().equals("Assertion")) {
                this.moSAMLAssertion = new Assertion(oChild);
            } else {
                String sChildName = oChild.getLocalName();
                Vector<Node> oVector = (Vector<Node>)this.moOtherChildrenVectorsMap.get(sChildName);
                if (oVector == null) {
                    oVector = new Vector<Node>();
                    this.moOtherChildrenVectorsMap.put(sChildName, oVector);
                }
                oVector.add(oChild.cloneNode(true));
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public Element toDOM(Document doc) {
        return this.toDOM(doc, false);
    }

    public Element toDOM(Document doc, boolean wantFiltered) {
        Element oLocal;
        int i;
        if (doc == null) {
            return null;
        }
        Element elem = doc.createElement("XRD");
        elem.setAttribute("xmlns", "xri://$xrd*($v*2.0)");
        if (!this.msXmlID.equals("")) {
            elem.setAttributeNS(null, "id", this.msXmlID);
        }
        if (this.query != null) {
            Element oResolved = this.query.toXML(doc);
            elem.appendChild(oResolved);
        }
        if (this.status != null) {
            Element oStatus = this.status.toXML(doc);
            elem.appendChild(oStatus);
        }
        if (this.expires != null) {
            Element oExpires = this.expires.toXML(doc);
            elem.appendChild(oExpires);
        }
        if (this.providerid != null) {
            Element oProviderid = this.providerid.toXML(doc);
            elem.appendChild(oProviderid);
        }
        for (i = 0; i < this.getNumLocalids(); ++i) {
            oLocal = this.getLocalidAt(i).toXML(doc);
            elem.appendChild(oLocal);
        }
        for (i = 0; i < this.getNumCanonicalids(); ++i) {
            oLocal = this.getCanonicalidAt(i).toXML(doc);
            elem.appendChild(oLocal);
        }
        if (wantFiltered) {
            ArrayList refs = this.getPrioritizedRefs();
            for (int i2 = 0; i2 < refs.size(); ++i2) {
                Ref r = (Ref)refs.get(i2);
                Element e = r.toXML(doc);
                elem.appendChild(e);
            }
            ArrayList svcs = this.getSelectedServices().getList();
            for (int i3 = 0; i3 < svcs.size(); ++i3) {
                Service s = (Service)svcs.get(i3);
                Element e = (Element)s.toDOM(doc, true);
                elem.appendChild(e);
            }
        } else {
            Element e;
            for (i = 0; i < this.getNumRefs(); ++i) {
                e = this.getRefAt(i).toXML(doc);
                elem.appendChild(e);
            }
            for (i = 0; i < this.getNumServices(); ++i) {
                e = (Element)this.getServiceAt(i).toDOM(doc);
                elem.appendChild(e);
            }
            if (this.moSAMLAssertion != null) {
                Element oSAMLElement = this.moSAMLAssertion.toDOM(doc);
                elem.appendChild(oSAMLElement);
            }
            Iterator oCustomTags = this.moOtherChildrenVectorsMap.keySet().iterator();
            while (oCustomTags.hasNext()) {
                String sTag = (String)oCustomTags.next();
                Vector oValues = (Vector)this.moOtherChildrenVectorsMap.get(sTag);
                for (int i4 = 0; i4 < oValues.size(); ++i4) {
                    Element oCustom = doc.createElement(sTag);
                    Node oChild = (Node)oValues.get(i4);
                    Node oChild2 = doc.importNode(oChild, true);
                    elem.appendChild(oChild2);
                }
            }
        }
        return elem;
    }

    public String serializeDOM(boolean bIndent, boolean bOmitXMLDeclaration) {
        this.getDOM();
        return DOMUtils.toString(this.moElem, bIndent, bOmitXMLDeclaration);
    }

    public String toString() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public String toResultString() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc, true);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public Element getDOM() {
        if (this.moElem == null) {
            this.moElem = this.toDOM((Document)new DocumentImpl());
            this.moElem.getOwnerDocument().appendChild(this.moElem);
        }
        return this.moElem;
    }

    public void setDOM(Element oElem) throws URISyntaxException, ParseException {
        this.fromDOM(oElem);
        this.moElem = oElem;
    }

    public void clearDOM() {
        this.moElem = null;
    }

    public void sign(PrivateKey oKey) throws XMLSecurityException {
        this.getDOM();
        Element oAssertionElem = DOMUtils.getFirstChildElement(this.moElem, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (oAssertionElem == null) {
            throw new XMLSecurityException("Cannot create signature. No SAML Assertion attached to descriptor.");
        }
        Element oSubjectElem = DOMUtils.getFirstChildElement(oAssertionElem, "urn:oasis:names:tc:SAML:2.0:assertion", "Subject");
        if (oSubjectElem == null) {
            throw new XMLSecurityException("Cannot create signature. SAML Assertion has no subject.");
        }
        String sIDAttrNS = null;
        String sIDAttr = "id";
        String sID = this.moElem.getAttributeNS(sIDAttrNS, sIDAttr);
        if (sID == null || sID.equals("")) {
            throw new XMLSecurityException("Cannot create signature. ID is missing for " + this.moElem.getLocalName());
        }
        DOM3Utils.bestEffortSetIDAttr(this.moElem, sIDAttrNS, sIDAttr);
        Document oDoc = this.moElem.getOwnerDocument();
        XMLSignature oSig = new XMLSignature(oDoc, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        String[] oTransforms = new String[]{"http://www.w3.org/2000/09/xmldsig#enveloped-signature", "http://www.w3.org/2001/10/xml-exc-c14n#"};
        Transforms oTrans = new Transforms(oSig.getDocument());
        for (int i = 0; i < oTransforms.length; ++i) {
            oTrans.addTransform(oTransforms[i]);
        }
        oSig.addDocument("#" + sID, oTrans);
        oSig.sign((Key)oKey);
        Element oSigElem = oSig.getElement();
        oAssertionElem.insertBefore(oSigElem, oSubjectElem);
    }

    public void verifySignature(PublicKey oPubKey) throws XMLSecurityException {
        if (this.moElem == null) {
            throw new XMLSecurityException("Cannot verify the signature. No DOM stored for XRD");
        }
        String sIDAttrNS = null;
        String sIDAttr = "id";
        String sID = this.moElem.getAttributeNS(sIDAttrNS, sIDAttr);
        if (sID == null || sID.equals("")) {
            throw new XMLSecurityException("Cannot verify the signature. ID is missing for " + this.moElem.getLocalName());
        }
        String sRef = "#" + sID;
        DOM3Utils.bestEffortSetIDAttr(this.moElem, sIDAttrNS, sIDAttr);
        Element oAssertionElem = DOMUtils.getFirstChildElement(this.moElem, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (oAssertionElem == null) {
            throw new XMLSecurityException("Cannot verify the signature. No Assertion in XRD");
        }
        Element oSigElem = DOMUtils.getFirstChildElement(oAssertionElem, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (oSigElem == null) {
            throw new XMLSecurityException("Cannot verify the signature. No signature in Assertion");
        }
        XMLSignature oSig = null;
        try {
            oSig = new XMLSignature(oSigElem, null);
        }
        catch (IOException oEx) {
            throw new XMLSecurityException("IOException: Signature Element could not be read");
        }
        Object sFailedRef = null;
        SignedInfo oSignedInfo = oSig.getSignedInfo();
        if (oSignedInfo.getLength() != 1) {
            throw new XMLSecurityException("Cannot verify the signature. Expected 1 reference, got " + oSignedInfo.getLength());
        }
        Reference oRef = oSignedInfo.item(0);
        String sURI = oRef.getURI();
        if (!sRef.equals(sURI)) {
            throw new XMLSecurityException("Cannot verify the signature. Reference URI did not match ID");
        }
        boolean bEnvelopedFound = false;
        Transforms oTransforms = oRef.getTransforms();
        for (int i = 0; i < oTransforms.getLength(); ++i) {
            String sTransform = oTransforms.item(i).getURI();
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(sTransform)) {
                bEnvelopedFound = true;
                continue;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(sTransform)) continue;
            throw new XMLSecurityException("Unexpected transform in signature");
        }
        if (!bEnvelopedFound) {
            throw new XMLSecurityException("Could not find expected http://www.w3.org/2000/09/xmldsig#enveloped-signature transform in signature");
        }
        if (!oSig.checkSignatureValue((Key)oPubKey)) {
            throw new XMLSecurityException("Signature failed to verify.");
        }
    }

    public boolean isValid() {
        return this.expires == null || this.expires.getDate() == null || !this.expires.getDate().before(new Date());
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusCode() throws XRIResolutionException {
        if (this.status == null) {
            throw new XRIResolutionException("No status code");
        }
        return this.status.getCode();
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Vector getServices() {
        return this.services == null ? null : this.services;
    }

    public void setServices(Collection col) {
        this.services = null;
        this.prioritizedServices = null;
        Iterator i = col.iterator();
        while (i.hasNext()) {
            Service s = (Service)i.next();
            this.addService(s);
        }
    }

    public void setSelectedServices(Collection svcs) {
        this.selectedServices = new PrioritizedList();
        Iterator i = svcs.iterator();
        while (i.hasNext()) {
            Service s = (Service)i.next();
            Integer priority = s.getPriority();
            String priStr = priority == null ? "null" : priority.toString();
            this.selectedServices.addObject(priStr, s);
        }
    }

    public PrioritizedList getSelectedServices() {
        return this.selectedServices == null ? new PrioritizedList() : this.selectedServices;
    }

    static {
        try {
            Init.init();
        }
        catch (Exception oEx) {
            soLog.warn((Object)"Failed to initialize XML Sec library", (Throwable)oEx);
        }
    }
}

