/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.proxy;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;

public final class Cas20ProxyRetriever
implements ProxyRetriever {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String casServerUrl;

    public Cas20ProxyRetriever(String casServerUrl) {
        CommonUtils.assertNotNull(casServerUrl, "casServerUrl cannot be null.");
        this.casServerUrl = casServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProxyTicketIdFor(String proxyGrantingTicketId, String targetService) {
        String url = this.constructUrl(proxyGrantingTicketId, targetService);
        HttpURLConnection conn = null;
        try {
            String response;
            StringBuffer stringBuffer;
            URL constructedUrl = new URL(url);
            conn = (HttpURLConnection)constructedUrl.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(255);
            synchronized (stringBuffer2) {
                String line;
                while ((line = in.readLine()) != null) {
                    stringBuffer.append(line);
                }
                response = stringBuffer.toString();
            }
            String error = XmlUtils.getTextForElement(response, "proxyFailure");
            if (CommonUtils.isNotEmpty(error)) {
                this.log.debug((Object)error);
                String string = null;
                return string;
            }
            String string = XmlUtils.getTextForElement(response, "proxyTicket");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String constructUrl(String proxyGrantingTicketId, String targetService) {
        try {
            return this.casServerUrl + "proxy" + "?pgt=" + proxyGrantingTicketId + "&targetService=" + URLEncoder.encode(targetService, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

