/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.htmlparser.NodeFilter;
import org.htmlparser.parserapplications.filterbuilder.Filter;
import org.htmlparser.parserapplications.filterbuilder.layouts.VerticalLayoutManager;

public class SubFilterList
extends JPanel {
    protected int mExtra = 25;
    protected Component mSpacer;
    protected Filter mHome;
    protected String mTitle;
    protected int mMax;

    public SubFilterList(Filter home, String title, int max) {
        this.mHome = home;
        this.mTitle = title;
        this.mMax = max;
        this.setLayout(new VerticalLayoutManager());
        this.addSpacer();
        this.setSelected(false);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBorder(new CompoundBorder(new TitledBorder(null, this.mTitle, 1, 2), new CompoundBorder(new LineBorder(Color.green, 2), new EmptyBorder(1, 1, 1, 1))));
        } else {
            this.setBorder(new CompoundBorder(new TitledBorder(null, this.mTitle, 1, 2), new EmptyBorder(3, 3, 3, 3)));
        }
    }

    protected void addSpacer() {
        Dimension dimension = this.mHome.getSize();
        Insets insets = this.mHome.getInsets();
        dimension.setSize(dimension.width - insets.left - insets.right, this.mExtra);
        this.mSpacer = Box.createRigidArea(dimension);
        this.add(this.mSpacer);
    }

    protected void removeSpacer() {
        this.remove(this.mSpacer);
        this.mSpacer = null;
    }

    public Component[] getDropTargets() {
        return new Component[]{this};
    }

    public void addFilter(Filter filter) {
        int count = this.getComponentCount();
        if (null != this.mSpacer) {
            --count;
        }
        this.addFilter(filter, count);
    }

    public void addFilter(Filter filter, int index) {
        this.add((Component)filter, index);
        NodeFilter[] before = this.mHome.getSubNodeFilters();
        NodeFilter[] after = new NodeFilter[before.length + 1];
        int offset = 0;
        for (int i = 0; i < after.length; ++i) {
            after[i] = i == index ? filter : before[offset++];
        }
        this.mHome.setSubNodeFilters(after);
        if (null != this.mSpacer && 0 != this.mMax && after.length >= this.mMax) {
            this.removeSpacer();
        }
    }

    public void removeFilter(Filter filter) {
        Filter[] filters = this.getFilters();
        int index = -1;
        for (int i = 0; -1 == index && i < filters.length; ++i) {
            if (filter != filters[i]) continue;
            index = i;
        }
        if (-1 != index) {
            this.removeFilter(index);
        }
    }

    public void removeFilter(int index) {
        this.remove(index);
        NodeFilter[] before = this.mHome.getSubNodeFilters();
        if (0 != before.length) {
            NodeFilter[] after = new NodeFilter[before.length - 1];
            int offset = 0;
            for (int i = 0; i < before.length; ++i) {
                if (i == index) continue;
                after[offset++] = before[i];
            }
            this.mHome.setSubNodeFilters(after);
            if (null == this.mSpacer && 0 != this.mMax && after.length < this.mMax) {
                this.addSpacer();
            }
        }
    }

    public Filter[] getFilters() {
        NodeFilter[] list = this.mHome.getSubNodeFilters();
        Filter[] ret = new Filter[list.length];
        System.arraycopy(list, 0, ret, 0, list.length);
        return ret;
    }

    public boolean canAccept() {
        boolean ret;
        if (0 == this.mMax) {
            ret = true;
        } else {
            int count = this.getComponentCount();
            if (null != this.mSpacer) {
                --count;
            }
            ret = count < this.mMax;
        }
        return ret;
    }

    public String toString(int indent, int level) {
        StringBuffer ret = new StringBuffer();
        Filter[] filters = this.getFilters();
        for (int i = 0; i < filters.length; ++i) {
            ret.append(filters[i].toString());
            if (i + 1 == filters.length) continue;
            ret.append("\n");
        }
        return ret.toString();
    }
}

