/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.anonymous;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.util.Assert;

public class AnonymousAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String key;
    static /* synthetic */ Class class$org$springframework$security$providers$anonymous$AnonymousAuthenticationToken;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.key, (String)"A Key is required");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (this.key.hashCode() != ((AnonymousAuthenticationToken)authentication).getKeyHash()) {
            throw new BadCredentialsException(this.messages.getMessage("AnonymousAuthenticationProvider.incorrectKey", "The presented AnonymousAuthenticationToken does not contain the expected key"));
        }
        return authentication;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public boolean supports(Class authentication) {
        return (class$org$springframework$security$providers$anonymous$AnonymousAuthenticationToken == null ? (class$org$springframework$security$providers$anonymous$AnonymousAuthenticationToken = AnonymousAuthenticationProvider.class$("org.springframework.security.providers.anonymous.AnonymousAuthenticationToken")) : class$org$springframework$security$providers$anonymous$AnonymousAuthenticationToken).isAssignableFrom(authentication);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

