/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.compensating.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.compensating.support.CompensatingTransactionHolderSupport;
import org.springframework.transaction.compensating.support.CompensatingTransactionObject;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractCompensatingTransactionManagerDelegate {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$transaction$compensating$support$AbstractCompensatingTransactionManagerDelegate == null ? (class$org$springframework$transaction$compensating$support$AbstractCompensatingTransactionManagerDelegate = AbstractCompensatingTransactionManagerDelegate.class$("org.springframework.transaction.compensating.support.AbstractCompensatingTransactionManagerDelegate")) : class$org$springframework$transaction$compensating$support$AbstractCompensatingTransactionManagerDelegate));
    static /* synthetic */ Class class$org$springframework$transaction$compensating$support$AbstractCompensatingTransactionManagerDelegate;

    protected abstract void closeTargetResource(CompensatingTransactionHolderSupport var1);

    protected abstract CompensatingTransactionHolderSupport getNewHolder();

    protected abstract Object getTransactionSynchronizationKey();

    public Object doGetTransaction() throws TransactionException {
        CompensatingTransactionHolderSupport holder = (CompensatingTransactionHolderSupport)((Object)TransactionSynchronizationManager.getResource((Object)this.getTransactionSynchronizationKey()));
        CompensatingTransactionObject txObject = new CompensatingTransactionObject(holder);
        return txObject;
    }

    public void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        CompensatingTransactionObject txObject = (CompensatingTransactionObject)transaction;
        if (txObject.getHolder() == null) {
            CompensatingTransactionHolderSupport contextHolder = this.getNewHolder();
            txObject.setHolder(contextHolder);
            TransactionSynchronizationManager.bindResource((Object)this.getTransactionSynchronizationKey(), (Object)((Object)contextHolder));
        }
    }

    public void doCommit(DefaultTransactionStatus status) throws TransactionException {
        CompensatingTransactionObject txObject = (CompensatingTransactionObject)status.getTransaction();
        txObject.getHolder().getTransactionOperationManager().commit();
    }

    public void doRollback(DefaultTransactionStatus status) throws TransactionException {
        CompensatingTransactionObject txObject = (CompensatingTransactionObject)status.getTransaction();
        txObject.getHolder().getTransactionOperationManager().rollback();
    }

    public void doCleanupAfterCompletion(Object transaction) {
        log.debug((Object)"Cleaning stored transaction synchronization");
        TransactionSynchronizationManager.unbindResource((Object)this.getTransactionSynchronizationKey());
        CompensatingTransactionObject txObject = (CompensatingTransactionObject)transaction;
        CompensatingTransactionHolderSupport transactionHolderSupport = txObject.getHolder();
        this.closeTargetResource(transactionHolderSupport);
        txObject.getHolder().clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

