class Entry {
    Person enteredBy
    Task task
    EntryType entryType
    String comment
    Date dateDone = new Date()
    Date dateEntered = new Date()
    Integer durationHour = 0
    Integer durationMinute = 0

    static belongsTo = [EntryType, Task, Person]

    static constraints = {
        task()
        comment(blank:false,maxSize:500)
        dateDone()
        durationHour(min:0)
        durationMinute(min:0,max:59)
        
    }

    String toString() {
        "${this.comment} - ${this.enteredBy}, ${this.dateDone}"
    }
}

