/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.anonymous;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.WebAuthenticationDetailsSource;
import org.springframework.security.userdetails.memory.UserAttribute;
import org.springframework.util.Assert;

public class AnonymousProcessingFilter
extends SpringSecurityFilter
implements InitializingBean {
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private String key;
    private UserAttribute userAttribute;
    private boolean removeAfterRequest = true;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userAttribute);
        Assert.hasLength((String)this.key);
    }

    protected boolean applyAnonymousForThisRequest(HttpServletRequest request) {
        return true;
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken(this.key, this.userAttribute.getPassword(), this.userAttribute.getAuthorities());
        auth.setDetails(this.authenticationDetailsSource.buildDetails(request));
        return auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean addedToken = false;
        if (this.applyAnonymousForThisRequest(request)) {
            if (SecurityContextHolder.getContext().getAuthentication() == null) {
                SecurityContextHolder.getContext().setAuthentication(this.createAuthentication(request));
                addedToken = true;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Populated SecurityContextHolder with anonymous token: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SecurityContextHolder not populated with anonymous token, as it already contained: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
            }
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (addedToken && this.removeAfterRequest && this.createAuthentication(request).equals(SecurityContextHolder.getContext().getAuthentication())) {
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }
    }

    public int getOrder() {
        return FilterChainOrder.ANONYMOUS_FILTER;
    }

    public String getKey() {
        return this.key;
    }

    public UserAttribute getUserAttribute() {
        return this.userAttribute;
    }

    public boolean isRemoveAfterRequest() {
        return this.removeAfterRequest;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setRemoveAfterRequest(boolean removeAfterRequest) {
        this.removeAfterRequest = removeAfterRequest;
    }

    public void setUserAttribute(UserAttribute userAttributeDefinition) {
        this.userAttribute = userAttributeDefinition;
    }
}

