/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;

public class RebindOperationExecutor
implements CompensatingTransactionOperationExecutor {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$transaction$compensating$RebindOperationExecutor == null ? (class$org$springframework$ldap$transaction$compensating$RebindOperationExecutor = RebindOperationExecutor.class$("org.springframework.ldap.transaction.compensating.RebindOperationExecutor")) : class$org$springframework$ldap$transaction$compensating$RebindOperationExecutor));
    private LdapOperations ldapOperations;
    private Name originalDn;
    private Name temporaryDn;
    private Object originalObject;
    private Attributes originalAttributes;
    static /* synthetic */ Class class$org$springframework$ldap$transaction$compensating$RebindOperationExecutor;

    public RebindOperationExecutor(LdapOperations ldapOperations, Name originalDn, Name temporaryDn, Object originalObject, Attributes originalAttributes) {
        this.ldapOperations = ldapOperations;
        this.originalDn = originalDn;
        this.temporaryDn = temporaryDn;
        this.originalObject = originalObject;
        this.originalAttributes = originalAttributes;
    }

    LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    public void rollback() {
        log.debug((Object)"Rolling back rebind operation");
        try {
            this.ldapOperations.unbind(this.originalDn);
            this.ldapOperations.rename(this.temporaryDn, this.originalDn);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to rollback operation, dn: " + this.originalDn + "; temporary DN: " + this.temporaryDn), (Throwable)e);
        }
    }

    public void commit() {
        log.debug((Object)"Committing rebind operation");
        this.ldapOperations.unbind(this.temporaryDn);
    }

    public void performOperation() {
        log.debug((Object)"Performing rebind operation - renaming original entry and binding new contents to entry.");
        this.ldapOperations.rename(this.originalDn, this.temporaryDn);
        this.ldapOperations.bind(this.originalDn, this.originalObject, this.originalAttributes);
    }

    Attributes getOriginalAttributes() {
        return this.originalAttributes;
    }

    Name getOriginalDn() {
        return this.originalDn;
    }

    Object getOriginalObject() {
        return this.originalObject;
    }

    Name getTemporaryDn() {
        return this.temporaryDn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

