/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.ParseStream;
import org.openxri.XRINoSchemePath;
import org.openxri.XRIPath;
import org.openxri.XRISegment;

public class XRIAbsolutePath
extends XRIPath {
    public XRIAbsolutePath(String sPath) {
        super(sPath);
        this.mbAllowColon = true;
        this.parse();
    }

    XRIAbsolutePath() {
        this.mbAllowColon = true;
    }

    XRIAbsolutePath(XRINoSchemePath oPath) {
        this.moSegments = oPath.moSegments;
        this.mbAllowColon = true;
    }

    boolean doScan(ParseStream oStream) {
        if (oStream.empty() || oStream.getData().charAt(0) != '/') {
            return false;
        }
        oStream.consume(1);
        super.scanXRISegments(oStream);
        return true;
    }

    public String toIRINormalForm() {
        return "/" + super.toIRINormalForm();
    }

    public boolean isPrefixOf(XRIAbsolutePath path) {
        int n = this.getNumSegments();
        if (n > path.getNumSegments()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            XRISegment seg = this.getSegmentAt(i);
            if (!(i == n - 1 ? !seg.isPrefixOf(path.getSegmentAt(i)) : !seg.equalsIgnoreCase(path.getSegmentAt(i)))) continue;
            return false;
        }
        return true;
    }
}

