/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.saml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.security.signature.XMLSignature;
import org.openxri.saml.AttributeStatement;
import org.openxri.saml.Conditions;
import org.openxri.saml.NameID;
import org.openxri.saml.Subject;
import org.openxri.util.DOMUtils;
import org.openxri.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Assertion {
    private static Log soLog = LogFactory.getLog((String)Assertion.class.getName());
    private String msXmlID = "";
    private String msIssueInstant = "";
    private Element moElem;
    private NameID moIssuer;
    private XMLSignature moSignature;
    private Subject moSubject;
    private Conditions moConditions;
    private AttributeStatement moAttrStatement;

    public Assertion() {
        this.genXmlID();
    }

    public Assertion(Element oElem) {
        this.fromDOM(oElem);
    }

    public String getIssueInstant() {
        return this.msIssueInstant;
    }

    public void setIssueInstant(String sVal) {
        this.msIssueInstant = sVal;
    }

    public String getXmlID() {
        return this.msXmlID;
    }

    public void setXmlID(String sVal) {
        this.msXmlID = sVal;
    }

    public void genXmlID() {
        this.msXmlID = "_" + XMLUtils.genXmlID();
    }

    public void setDOM(Element oElem) {
        this.fromDOM(oElem);
        this.moElem = oElem;
    }

    public void reset() {
        this.msXmlID = "";
        this.msIssueInstant = "";
        this.moElem = null;
        this.moIssuer = null;
        this.moSignature = null;
        this.moSubject = null;
        this.moConditions = null;
        this.moAttrStatement = null;
    }

    public void fromDOM(Element oElem) {
        this.reset();
        if (oElem.hasAttributeNS(null, "ID")) {
            this.msXmlID = oElem.getAttributeNS(null, "ID");
        }
        if (oElem.hasAttributeNS(null, "IssueInstant")) {
            this.msIssueInstant = oElem.getAttributeNS(null, "IssueInstant");
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            if (oChild.getLocalName().equals("Issuer")) {
                if (this.moIssuer == null) {
                    this.moIssuer = new NameID(oChild);
                }
            } else if (oChild.getLocalName().equals("Signature")) {
                if (this.moSignature == null) {
                    try {
                        DocumentImpl oDoc = new DocumentImpl();
                        Element oChildCopy = (Element)oDoc.importNode(oChild, true);
                        this.moSignature = new XMLSignature(oChildCopy, null);
                    }
                    catch (Exception oEx) {
                        soLog.warn((Object)"Caught exception while parsing Signature", (Throwable)oEx);
                    }
                }
            } else if (oChild.getLocalName().equals("Subject")) {
                if (this.moSubject == null) {
                    this.moSubject = new Subject(oChild);
                }
            } else if (oChild.getLocalName().equals("Conditions")) {
                if (this.moConditions == null) {
                    this.moConditions = new Conditions(oChild);
                }
            } else if (oChild.getLocalName().equals("AttributeStatement") && this.moAttrStatement == null) {
                this.moAttrStatement = new AttributeStatement(oChild);
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public Element getDOM() {
        if (this.moElem == null) {
            this.moElem = this.toDOM((Document)new DocumentImpl());
            this.moElem.getOwnerDocument().appendChild(this.moElem);
        }
        return this.moElem;
    }

    public boolean isValid() {
        if (this.msIssueInstant.equals("") || this.msXmlID.equals("") || this.moIssuer == null) {
            return false;
        }
        return this.moConditions == null || this.moConditions.isValid();
    }

    public AttributeStatement getAttributeStatement() {
        return this.moAttrStatement;
    }

    public Element toDOM(Document oDoc) {
        Element oChildElem;
        if (oDoc == null) {
            return null;
        }
        Element oElem = oDoc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        oElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:assertion");
        oElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        oElem.setPrefix("saml");
        oElem.setAttributeNS(null, "Version", "2.0");
        oElem.setAttributeNS(null, "ID", this.msXmlID);
        oElem.setAttributeNS(null, "IssueInstant", this.msIssueInstant);
        if (this.moIssuer != null) {
            oChildElem = this.moIssuer.toDOM(oDoc);
            oElem.appendChild(oChildElem);
        }
        if (this.moSignature != null) {
            oChildElem = this.moSignature.getElement();
            oChildElem = (Element)oDoc.importNode(oChildElem, true);
            oElem.appendChild(oChildElem);
        }
        if (this.moSubject != null) {
            oChildElem = this.moSubject.toDOM(oDoc);
            oElem.appendChild(oChildElem);
        }
        if (this.moConditions != null) {
            oChildElem = this.moConditions.toDOM(oDoc);
            oElem.appendChild(oChildElem);
        }
        if (this.moAttrStatement != null) {
            oChildElem = this.moAttrStatement.toDOM(oDoc);
            oElem.appendChild(oChildElem);
        }
        return oElem;
    }

    public Subject getSubject() {
        return this.moSubject;
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public NameID getIssuer() {
        return this.moIssuer;
    }

    public void setIssuer(NameID oIssuer) {
        this.moIssuer = oIssuer;
    }

    public Conditions getConditions() {
        return this.moConditions;
    }

    public void setConditions(Conditions oVal) {
        this.moConditions = oVal;
    }

    public void setAttrStatement(AttributeStatement oVal) {
        this.moAttrStatement = oVal;
    }

    public void setSubject(Subject oVal) {
        this.moSubject = oVal;
    }
}

