/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractFallbackMethodDefinitionSource
implements MethodDefinitionSource {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$intercept$method$AbstractFallbackMethodDefinitionSource == null ? (class$org$springframework$security$intercept$method$AbstractFallbackMethodDefinitionSource = AbstractFallbackMethodDefinitionSource.class$("org.springframework.security.intercept.method.AbstractFallbackMethodDefinitionSource")) : class$org$springframework$security$intercept$method$AbstractFallbackMethodDefinitionSource));
    private static final Object NULL_CONFIG_ATTRIBUTE = new Object();
    private final Map attributeCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$security$intercept$method$AbstractFallbackMethodDefinitionSource;
    static /* synthetic */ Class class$org$aopalliance$intercept$MethodInvocation;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint;

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        Assert.notNull((Object)object, (String)"Object cannot be null");
        if (object instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)object;
            Object target = mi.getThis();
            return this.getAttributes(mi.getMethod(), target == null ? null : target.getClass());
        }
        if (object instanceof JoinPoint) {
            JoinPoint jp = (JoinPoint)object;
            Class<?> targetClass = jp.getTarget().getClass();
            String targetMethodName = jp.getStaticPart().getSignature().getName();
            Class[] types = ((CodeSignature)jp.getStaticPart().getSignature()).getParameterTypes();
            Class declaringType = ((CodeSignature)jp.getStaticPart().getSignature()).getDeclaringType();
            Method method = ClassUtils.getMethodIfAvailable((Class)declaringType, (String)targetMethodName, (Class[])types);
            Assert.notNull((Object)method, (String)("Could not obtain target method from JoinPoint: '" + jp + "'"));
            return this.getAttributes(method, targetClass);
        }
        throw new IllegalArgumentException("Object must be a MethodInvocation or JoinPoint");
    }

    public final boolean supports(Class clazz) {
        return (class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AbstractFallbackMethodDefinitionSource.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation).isAssignableFrom(clazz) || (class$org$aspectj$lang$JoinPoint == null ? (class$org$aspectj$lang$JoinPoint = AbstractFallbackMethodDefinitionSource.class$("org.aspectj.lang.JoinPoint")) : class$org$aspectj$lang$JoinPoint).isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigAttributeDefinition getAttributes(Method method, Class targetClass) {
        DefaultCacheKey cacheKey = new DefaultCacheKey(method, targetClass);
        Map map = this.attributeCache;
        synchronized (map) {
            Object cached = this.attributeCache.get(cacheKey);
            if (cached != null) {
                if (cached == NULL_CONFIG_ATTRIBUTE) {
                    return null;
                }
                return (ConfigAttributeDefinition)cached;
            }
            ConfigAttributeDefinition cfgAtt = this.computeAttributes(method, targetClass);
            if (cfgAtt == null) {
                this.attributeCache.put(cacheKey, NULL_CONFIG_ATTRIBUTE);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding security method [" + cacheKey + "] with attribute [" + cfgAtt + "]"));
                }
                this.attributeCache.put(cacheKey, cfgAtt);
            }
            return cfgAtt;
        }
    }

    private ConfigAttributeDefinition computeAttributes(Method method, Class targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
        ConfigAttributeDefinition attr = this.findAttributes(specificMethod, targetClass);
        if (attr != null) {
            return attr;
        }
        attr = this.findAttributes(specificMethod.getDeclaringClass());
        if (attr != null) {
            return attr;
        }
        if (specificMethod != method || targetClass == null) {
            attr = this.findAttributes(method, method.getDeclaringClass());
            if (attr != null) {
                return attr;
            }
            return this.findAttributes(method.getDeclaringClass());
        }
        return null;
    }

    protected abstract ConfigAttributeDefinition findAttributes(Method var1, Class var2);

    protected abstract ConfigAttributeDefinition findAttributes(Class var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ Collection getConfigAttributeDefinitions();

    private static class DefaultCacheKey {
        private final Method method;
        private final Class targetClass;

        public DefaultCacheKey(Method method, Class targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey otherKey = (DefaultCacheKey)other;
            return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals((Object)this.targetClass, (Object)otherKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() * 21 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        }

        public String toString() {
            return "CacheKey[" + (this.targetClass == null ? "-" : this.targetClass.getName()) + "; " + this.method + "]";
        }
    }
}

