/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.openxri.XRIParseException;
import org.openxri.util.DOMUtils;
import org.openxri.util.PrioritizedList;
import org.openxri.xml.SEPElement;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Service
implements Cloneable {
    private static Log soLog = LogFactory.getLog((String)Service.class.getName());
    private String providerID = "";
    private Vector types = null;
    private Vector paths = null;
    private Vector mediaTypes = null;
    private Integer priority = null;
    private KeyInfo moKeyInfo = null;
    private HashMap otherChildrenVectorMap = new HashMap();
    private Vector uris = null;
    private PrioritizedList prioritizedURIs = null;

    public Service() {
    }

    public Service(Element oElem) throws URISyntaxException {
        this.fromDOM(oElem);
    }

    public void reset() {
        this.types = null;
        this.mediaTypes = null;
        this.paths = null;
        this.uris = null;
        this.otherChildrenVectorMap = new HashMap();
    }

    public void fromDOM(Element oElem) throws URISyntaxException {
        this.reset();
        String val = oElem.getAttribute("priority");
        if (val != null && val.length() > 0) {
            this.setPriority(new Integer(val));
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            String sChildName = oChild.getLocalName();
            String sChildValue = "";
            if (oChild.getFirstChild() != null && oChild.getFirstChild().getNodeType() == 3) {
                sChildValue = oChild.getFirstChild().getNodeValue();
            }
            if (sChildName.equals("Type")) {
                if (this.types == null) {
                    this.types = new Vector();
                }
                this.types.add(SEPType.fromXML(oChild));
            } else if (sChildName.equals("ProviderID")) {
                this.setProviderID(oChild.getFirstChild().getNodeValue());
            } else if (sChildName.equals("Path")) {
                if (this.paths == null) {
                    this.paths = new Vector();
                }
                this.paths.add(SEPPath.fromXML(oChild));
            } else if (sChildName.equals("MediaType")) {
                if (this.mediaTypes == null) {
                    this.mediaTypes = new Vector();
                }
                this.mediaTypes.add(SEPMediaType.fromXML(oChild));
            } else if (sChildName.equals("URI")) {
                if (this.uris == null) {
                    this.uris = new Vector();
                }
                this.addURI(SEPUri.fromXML(oChild));
            } else if (oChild.getNamespaceURI() != null && oChild.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && oChild.getLocalName() != null && oChild.getLocalName().equals("KeyInfo")) {
                try {
                    this.moKeyInfo = new KeyInfo(oChild, "");
                }
                catch (XMLSecurityException oEx) {
                    soLog.warn((Object)"Error constructing KeyInfo.", (Throwable)oEx);
                }
            } else {
                Vector<Node> oVector = (Vector<Node>)this.otherChildrenVectorMap.get(sChildName);
                if (oVector == null) {
                    oVector = new Vector<Node>();
                    this.otherChildrenVectorMap.put(sChildName, oVector);
                }
                oVector.add(oChild.cloneNode(true));
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public String getMediaType() {
        soLog.warn((Object)"getMediaType - deprecated.");
        SEPMediaType mtype = this.getMediaTypeAt(0);
        return mtype != null ? mtype.getValue() : null;
    }

    public int getNumMediaTypes() {
        return this.mediaTypes == null ? 0 : this.mediaTypes.size();
    }

    public SEPMediaType getMediaTypeAt(int n) {
        if (this.mediaTypes != null) {
            return (SEPMediaType)this.mediaTypes.get(n);
        }
        return null;
    }

    public void setMediaType(String sVal) {
        soLog.warn((Object)"setMediaType - deprecated.");
        this.mediaTypes = new Vector();
        SEPMediaType mediaType = new SEPMediaType(sVal, null, null);
        this.mediaTypes.add(mediaType);
    }

    public void addMediaType(String sVal) {
        this.addMediaType(sVal, null, null);
    }

    public void addMediaType(String sVal, String match, Boolean select) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new Vector();
        }
        SEPMediaType mediaType = new SEPMediaType(sVal, match, select);
        this.mediaTypes.add(mediaType);
    }

    public String getType() {
        soLog.warn((Object)"getType is deprecated.");
        SEPType type = this.getTypeAt(0);
        return type != null ? type.getValue() : null;
    }

    public int getNumTypes() {
        return this.types == null ? 0 : this.types.size();
    }

    public SEPType getTypeAt(int n) {
        if (this.types != null) {
            return (SEPType)this.types.get(n);
        }
        return null;
    }

    public void setType(String sVal) {
        soLog.warn((Object)"setType is deprecated.");
        this.types = new Vector();
        this.types.add(new SEPType(sVal, null, null));
    }

    public void addType(String sVal) {
        this.addType(sVal, null, null);
    }

    public void addType(String sVal, String match, Boolean select) {
        if (this.types == null) {
            this.types = new Vector();
        }
        this.types.add(new SEPType(sVal, match, select));
    }

    public boolean matchType(String sVal) {
        for (int i = 0; i < this.getNumTypes(); ++i) {
            SEPType type = this.getTypeAt(i);
            if (!type.match(sVal)) continue;
            return true;
        }
        return false;
    }

    public int getNumURIs() {
        return this.uris == null ? 0 : this.uris.size();
    }

    public SEPUri getURI() {
        soLog.warn((Object)"getURI is deprecated.");
        return this.getURIAt(0);
    }

    public SEPUri getURIAt(int n) {
        return n < this.getNumURIs() ? (SEPUri)this.uris.get(n) : null;
    }

    public SEPUri getURIForScheme(String sScheme) {
        if (sScheme == null) {
            return null;
        }
        for (int i = 0; i < this.getNumURIs(); ++i) {
            SEPUri oURI = this.getURIAt(i);
            if (oURI == null || oURI.getURI() == null || !oURI.getURI().getScheme().equalsIgnoreCase(sScheme)) continue;
            return oURI;
        }
        return null;
    }

    public Vector getURIs() {
        return this.uris;
    }

    public ArrayList getPrioritizedURIs() {
        if (this.prioritizedURIs == null) {
            return new ArrayList();
        }
        return this.prioritizedURIs.getList();
    }

    public void addURI(String sURI) {
        this.addURI(sURI, null, null);
    }

    public void addURI(String sURI, Integer priority, String append) {
        try {
            SEPUri uri = new SEPUri(sURI, priority, append);
            this.addURI(uri);
        }
        catch (Exception e) {
            throw new XRIParseException("BadURI", e);
        }
    }

    public void addURI(SEPUri uri) {
        if (this.uris == null || this.prioritizedURIs == null) {
            this.uris = new Vector();
            this.prioritizedURIs = new PrioritizedList();
        }
        this.uris.add(uri);
        Integer priority = uri.getPriority();
        this.prioritizedURIs.addObject(priority == null ? "null" : priority.toString(), uri);
    }

    public SEPPath getPathAt(int n) {
        return n < this.getNumPaths() ? (SEPPath)this.paths.get(n) : null;
    }

    public void addPath(String sPath) {
        this.addPath(sPath, null, null);
    }

    public void addPath(String sPath, String match, Boolean select) {
        if (this.paths == null) {
            this.paths = new Vector();
        }
        try {
            this.paths.add(new SEPPath(sPath, match, select));
        }
        catch (Exception e) {
            throw new XRIParseException("BadPath", e);
        }
    }

    public int getNumPaths() {
        return this.paths == null ? 0 : this.paths.size();
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String sAuthorityID) {
        this.providerID = sAuthorityID;
    }

    public void setKeyInfo(KeyInfo oKeyInfo) {
        this.moKeyInfo = oKeyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.moKeyInfo;
    }

    public boolean setOtherTagValues(String sTag, String sTagValue) {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sTagValue;
        boolean returnValue = false;
        try {
            ByteArrayInputStream oIn = new ByteArrayInputStream(xmlStr.getBytes());
            DOMParser oDOMParser = DOMUtils.getDOMParser();
            oDOMParser.parse(new InputSource(oIn));
            Document oDOMDoc = oDOMParser.getDocument();
            Element oElement = oDOMDoc.getDocumentElement();
            Vector<Node> oVector = (Vector<Node>)this.otherChildrenVectorMap.get(sTag);
            if (oVector == null) {
                oVector = new Vector<Node>();
                this.otherChildrenVectorMap.put(sTag, oVector);
            }
            oVector.add(oElement.cloneNode(true));
            returnValue = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            returnValue = false;
        }
        return returnValue;
    }

    public Vector getOtherTagValues(String sTag) {
        return (Vector)this.otherChildrenVectorMap.get(sTag);
    }

    public Node toDOM(Document oDoc) {
        return this.toDOM(oDoc, false);
    }

    public Node toDOM(Document oDoc, boolean wantFiltered) {
        int i;
        Element oElem = oDoc.createElementNS("xri://$xrd*($v*2.0)", "Service");
        if (this.getPriority() != null) {
            oElem.setAttribute("priority", this.getPriority().toString());
        }
        for (i = 0; i < this.getNumTypes(); ++i) {
            SEPType type = this.getTypeAt(i);
            oElem.appendChild(type.toXML(oDoc, "Type"));
        }
        if (this.getProviderID() != null) {
            Element providerid = oDoc.createElement("ProviderID");
            providerid.appendChild(oDoc.createTextNode(this.getProviderID()));
            oElem.appendChild(providerid);
        }
        for (i = 0; i < this.getNumPaths(); ++i) {
            SEPPath path = this.getPathAt(i);
            oElem.appendChild(path.toXML(oDoc, "Path"));
        }
        for (i = 0; i < this.getNumMediaTypes(); ++i) {
            SEPMediaType mtype = this.getMediaTypeAt(i);
            oElem.appendChild(mtype.toXML(oDoc, "MediaType"));
        }
        if (wantFiltered) {
            ArrayList uris = this.getPrioritizedURIs();
            for (int i2 = 0; i2 < uris.size(); ++i2) {
                SEPUri u = (SEPUri)uris.get(i2);
                oElem.appendChild(u.toXML(oDoc, "URI"));
            }
        } else {
            for (i = 0; i < this.getNumURIs(); ++i) {
                SEPUri uri = this.getURIAt(i);
                oElem.appendChild(uri.toXML(oDoc, "URI"));
            }
        }
        Iterator oCustomTags = this.otherChildrenVectorMap.keySet().iterator();
        while (oCustomTags.hasNext()) {
            String sTag = (String)oCustomTags.next();
            Vector oValues = (Vector)this.otherChildrenVectorMap.get(sTag);
            for (int i3 = 0; i3 < oValues.size(); ++i3) {
                Element oCustom = oDoc.createElement(sTag);
                Node oChild = (Node)oValues.get(i3);
                Node oChild2 = oDoc.importNode(oChild, true);
                oElem.appendChild(oChild2);
            }
        }
        return oElem;
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        DocumentImpl doc = new DocumentImpl();
        Node elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Vector getMediaTypes() {
        return this.mediaTypes == null ? new Vector() : this.mediaTypes;
    }

    public HashMap getOtherChildrenVectorMap() {
        return this.otherChildrenVectorMap;
    }

    public Vector getPaths() {
        return this.paths == null ? new Vector() : this.paths;
    }

    public Vector getTypes() {
        return this.types == null ? new Vector() : this.types;
    }

    public void addType(SEPType type) {
        if (type == null) {
            return;
        }
        if (this.types == null) {
            this.types = new Vector();
        }
        this.types.add(type);
    }

    public void addMediaType(SEPMediaType mtype) {
        if (mtype == null) {
            return;
        }
        if (this.mediaTypes == null) {
            this.mediaTypes = new Vector();
        }
        this.mediaTypes.add(mtype);
    }

    public void addPath(SEPPath path) {
        if (path == null) {
            return;
        }
        if (this.paths == null) {
            this.paths = new Vector();
        }
        this.paths.add(path);
    }

    public void setPrioritizedURIs(PrioritizedList prioritizedURIs) {
        this.prioritizedURIs = prioritizedURIs;
    }

    public Object clone() throws CloneNotSupportedException {
        Object element;
        int i;
        Service srvc = new Service();
        srvc.moKeyInfo = this.moKeyInfo;
        srvc.otherChildrenVectorMap = this.otherChildrenVectorMap;
        srvc.prioritizedURIs = this.prioritizedURIs;
        srvc.priority = this.priority;
        srvc.providerID = this.providerID;
        srvc.uris = null;
        srvc.types = null;
        srvc.mediaTypes = null;
        srvc.paths = null;
        Vector<Object> elements = null;
        if (this.types != null) {
            elements = new Vector<Object>();
            for (i = 0; i < this.types.size(); ++i) {
                element = (SEPElement)this.types.get(i);
                elements.add(((SEPElement)element).clone());
            }
            srvc.types = elements;
        }
        if (this.mediaTypes != null) {
            elements = new Vector();
            for (i = 0; i < this.mediaTypes.size(); ++i) {
                element = (SEPElement)this.mediaTypes.get(i);
                elements.add(((SEPElement)element).clone());
            }
            srvc.mediaTypes = elements;
        }
        if (this.paths != null) {
            elements = new Vector();
            for (i = 0; i < this.paths.size(); ++i) {
                element = (SEPElement)this.paths.get(i);
                elements.add(((SEPElement)element).clone());
            }
            srvc.paths = elements;
        }
        if (this.uris != null) {
            elements = new Vector();
            for (i = 0; i < this.uris.size(); ++i) {
                element = (SEPUri)this.uris.get(i);
                elements.add(((SEPUri)element).clone());
            }
            srvc.uris = elements;
        }
        return srvc;
    }

    public void setMediaTypes(Vector mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setPaths(Vector paths) {
        this.paths = paths;
    }

    public void setTypes(Vector types) {
        this.types = types;
    }
}

