/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import java.util.Iterator;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.ldap.SpringSecurityContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.springframework.util.Assert;

public class BindAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator == null ? (class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator = BindAuthenticator.class$("org.springframework.security.providers.ldap.authenticator.BindAuthenticator")) : class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator));
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator;
    static /* synthetic */ Class class$org$springframework$security$providers$UsernamePasswordAuthenticationToken;

    public BindAuthenticator(SpringSecurityContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    public DirContextOperations authenticate(Authentication authentication) {
        DirContextOperations user = null;
        Assert.isInstanceOf((Class)(class$org$springframework$security$providers$UsernamePasswordAuthenticationToken == null ? (class$org$springframework$security$providers$UsernamePasswordAuthenticationToken = BindAuthenticator.class$("org.springframework.security.providers.UsernamePasswordAuthenticationToken")) : class$org$springframework$security$providers$UsernamePasswordAuthenticationToken), (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        Iterator dns = this.getUserDns(username).iterator();
        while (dns.hasNext() && user == null) {
            user = this.bindWithDn((String)dns.next(), username, password);
        }
        if (user == null && this.getUserSearch() != null) {
            DirContextOperations userFromSearch = this.getUserSearch().searchForUser(username);
            user = this.bindWithDn(userFromSearch.getDn().toString(), username, password);
        }
        if (user == null) {
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    private DirContextOperations bindWithDn(String userDn, String username, String password) {
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(new BindWithSpecificDnContextSource((SpringSecurityContextSource)this.getContextSource(), userDn, password));
        try {
            return template.retrieveEntry(userDn, this.getUserAttributes());
        }
        catch (BadCredentialsException e) {
            this.handleBindException(userDn, username, e.getCause());
            return null;
        }
    }

    protected void handleBindException(String userDn, String username, Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to bind as " + userDn + ": " + cause));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BindWithSpecificDnContextSource
    implements ContextSource {
        private SpringSecurityContextSource ctxFactory;
        DistinguishedName userDn;
        private String password;

        public BindWithSpecificDnContextSource(SpringSecurityContextSource ctxFactory, String userDn, String password) {
            this.ctxFactory = ctxFactory;
            this.userDn = new DistinguishedName(userDn);
            this.userDn.prepend(ctxFactory.getBaseLdapPath());
            this.password = password;
        }

        public DirContext getReadOnlyContext() throws DataAccessException {
            return this.ctxFactory.getReadWriteContext(this.userDn.toString(), this.password);
        }

        public DirContext getReadWriteContext() throws DataAccessException {
            return this.getReadOnlyContext();
        }
    }
}

