/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SEPElement
implements Cloneable {
    protected static Log soLog = LogFactory.getLog((String)XRD.class.getName());
    public static final String MATCH_ATTR_DEFAULT = "default";
    public static final String MATCH_ATTR_CONTENT = "content";
    public static final String MATCH_ATTR_ANY = "any";
    public static final String MATCH_ATTR_NON_NULL = "non-null";
    public static final String MATCH_ATTR_NULL = "null";
    public static final String MATCH_ATTR_NONE = "none";
    public static final String SELECT_ATTR_TRUE = "true";
    public static final String SELECT_ATTR_FALSE = "false";
    public static final String DEFAULT_SELECT_ATTR = "false";
    public static final boolean DEFAULT_SELECT_ATTR_BOOL = false;
    private String match;
    private Boolean select;
    private String value;

    public SEPElement() {
        this(null, null, null);
    }

    public SEPElement(String value, String match, Boolean select) {
        this.match = match;
        this.select = select;
        this.value = value;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public boolean getSelect() {
        if (this.select != null) {
            return this.select;
        }
        return false;
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public void setSelect(String select) {
        this.select = select.equalsIgnoreCase(SELECT_ATTR_TRUE) || select.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Element toXML(Document doc, String tag) {
        Element body = doc.createElement(tag);
        if (this.match != null) {
            body.setAttribute("match", this.match);
        }
        if (this.select != null) {
            body.setAttribute("select", this.select.toString());
        }
        if (this.value != null) {
            body.appendChild(doc.createTextNode(this.value));
        }
        return body;
    }

    public void setFromXML(Node root) {
        Element el = (Element)root;
        if (el.hasAttribute("match")) {
            this.setMatch(el.getAttribute("match").trim());
        }
        if (el.hasAttribute("select")) {
            this.setSelect(el.getAttribute("select").trim());
        }
        this.setValue(DOMUtils.getText(root));
    }

    protected String toString(String tag) {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toXML((Document)doc, tag);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

