/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.RecordState;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;

public final class MockInvocationHandler
implements InvocationHandler {
    final MocksControl control;

    public MockInvocationHandler(MocksControl control) {
        this.control = control;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.control.getState() instanceof RecordState) {
                LastControl.reportLastControl(this.control);
            }
            return this.control.getState().invoke(new Invocation(proxy, method, args));
        }
        catch (RuntimeExceptionWrapper e) {
            throw e.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper e) {
            throw ((Throwable)((Object)e.getAssertionError())).fillInStackTrace();
        }
        catch (ThrowableWrapper t) {
            throw t.getThrowable().fillInStackTrace();
        }
    }

    public MocksControl getControl() {
        return this.control;
    }
}

