/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.cas;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.cas.ServiceProperties;
import org.springframework.util.Assert;

public class CasProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private ServiceProperties serviceProperties;
    private String loginUrl;
    private boolean encodeServiceUrlWithSessionId = true;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.loginUrl, (String)"loginUrl must be specified");
        Assert.notNull((Object)this.serviceProperties, (String)"serviceProperties must be specified");
    }

    public void commence(ServletRequest servletRequest, ServletResponse servletResponse, AuthenticationException authenticationException) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String urlEncodedService = CommonUtils.constructServiceUrl(null, (HttpServletResponse)response, (String)this.serviceProperties.getService(), null, (String)"ticket", (boolean)this.encodeServiceUrlWithSessionId);
        String redirectUrl = CommonUtils.constructRedirectUrl((String)this.loginUrl, (String)"service", (String)urlEncodedService, (boolean)this.serviceProperties.isSendRenew(), (boolean)false);
        response.sendRedirect(redirectUrl);
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public void setEncodeServiceUrlWithSessionId(boolean encodeServiceUrlWithSessionId) {
        this.encodeServiceUrlWithSessionId = encodeServiceUrlWithSessionId;
    }
}

