/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.websphere;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.MutableGrantedAuthoritiesContainer;
import org.springframework.security.authoritymapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.authoritymapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.ui.AuthenticationDetailsSourceImpl;
import org.springframework.security.ui.preauth.websphere.WASSecurityHelper;
import org.springframework.util.Assert;

public class WebSpherePreAuthenticatedAuthenticationDetailsSource
extends AuthenticationDetailsSourceImpl
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$springframework$security$ui$preauth$websphere$WebSpherePreAuthenticatedAuthenticationDetailsSource == null ? (class$org$springframework$security$ui$preauth$websphere$WebSpherePreAuthenticatedAuthenticationDetailsSource = WebSpherePreAuthenticatedAuthenticationDetailsSource.class$("org.springframework.security.ui.preauth.websphere.WebSpherePreAuthenticatedAuthenticationDetailsSource")) : class$org$springframework$security$ui$preauth$websphere$WebSpherePreAuthenticatedAuthenticationDetailsSource));
    private Attributes2GrantedAuthoritiesMapper webSphereGroups2GrantedAuthoritiesMapper = new SimpleAttributes2GrantedAuthoritiesMapper();
    static /* synthetic */ Class class$org$springframework$security$ui$preauth$websphere$WebSpherePreAuthenticatedAuthenticationDetailsSource;
    static /* synthetic */ Class class$org$springframework$security$ui$preauth$PreAuthenticatedGrantedAuthoritiesAuthenticationDetails;

    public WebSpherePreAuthenticatedAuthenticationDetailsSource() {
        super.setClazz(class$org$springframework$security$ui$preauth$PreAuthenticatedGrantedAuthoritiesAuthenticationDetails == null ? (class$org$springframework$security$ui$preauth$PreAuthenticatedGrantedAuthoritiesAuthenticationDetails = WebSpherePreAuthenticatedAuthenticationDetailsSource.class$("org.springframework.security.ui.preauth.PreAuthenticatedGrantedAuthoritiesAuthenticationDetails")) : class$org$springframework$security$ui$preauth$PreAuthenticatedGrantedAuthoritiesAuthenticationDetails);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.webSphereGroups2GrantedAuthoritiesMapper, (String)"WebSphere groups to granted authorities mapper not set");
    }

    public Object buildDetails(Object context) {
        Object result = super.buildDetails(context);
        if (result instanceof MutableGrantedAuthoritiesContainer) {
            ((MutableGrantedAuthoritiesContainer)result).setGrantedAuthorities(this.getWebSphereGroupsBasedGrantedAuthorities());
        }
        return result;
    }

    private GrantedAuthority[] getWebSphereGroupsBasedGrantedAuthorities() {
        String[] webSphereGroups = WASSecurityHelper.getGroupsForCurrentUser();
        GrantedAuthority[] userGas = this.webSphereGroups2GrantedAuthoritiesMapper.getGrantedAuthorities(webSphereGroups);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebSphere groups: " + Arrays.asList(webSphereGroups) + " mapped to Granted Authorities: " + Arrays.asList(userGas)));
        }
        return userGas;
    }

    public void setWebSphereGroups2GrantedAuthoritiesMapper(Attributes2GrantedAuthoritiesMapper mapper) {
        this.webSphereGroups2GrantedAuthoritiesMapper = mapper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

