/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.IRIUtils;
import org.openxri.ParseStream;
import org.openxri.XRIAuthority;
import org.openxri.XRISegment;

public class GCSAuthority
extends XRIAuthority {
    private String msGCSRoot;

    public GCSAuthority(String sPath) {
        super(sPath);
        this.parse();
    }

    GCSAuthority() {
    }

    boolean doScan(ParseStream oStream) {
        if (!this.scanGCSChar(oStream)) {
            return false;
        }
        XRISegment oSegment = new XRISegment(true, true, !this.msGCSRoot.equals("!"));
        if (oSegment.scan(oStream)) {
            this.moSegment = oSegment;
        }
        return true;
    }

    private boolean scanGCSChar(ParseStream oParseStream) {
        if (oParseStream.empty()) {
            return false;
        }
        switch (oParseStream.getData().charAt(0)) {
            case '!': 
            case '$': 
            case '+': 
            case '=': 
            case '@': {
                this.msGCSRoot = Character.toString(oParseStream.getData().charAt(0));
                oParseStream.consume(1);
                return true;
            }
        }
        return false;
    }

    public char getGCSRootAsChar() {
        this.parse();
        return this.msGCSRoot.charAt(0);
    }

    public String getGCSRoot() {
        this.parse();
        return this.msGCSRoot;
    }

    public String toIRINormalForm() {
        String sValue = this.msGCSRoot;
        if (this.moSegment != null) {
            sValue = sValue + this.moSegment.toIRINormalForm();
        }
        return sValue;
    }

    public String toURINormalForm() {
        return IRIUtils.IRItoURI(this.toIRINormalForm());
    }

    public String getRootAuthority() {
        return this.getGCSRoot();
    }

    public XRIAuthority getParent() {
        this.parse();
        if (this.moSegment == null) {
            return null;
        }
        GCSAuthority oParent = new GCSAuthority();
        oParent.msGCSRoot = this.msGCSRoot;
        oParent.moSegment = this.moSegment.getParent();
        oParent.msValue = this.msGCSRoot + oParent.moSegment.toString();
        oParent.mbParsed = true;
        oParent.mbParseResult = this.mbParseResult;
        return oParent;
    }
}

